import React, { useState, useEffect } from 'react';
import axios from 'axios';
import ScheduleForm from './ScheduleForm';
import Modal from '../../Layouts/Modal';

const ScheduleUpdate = ({ scheduleId, onClose }) => {
  const [scheduleData, setScheduleData] = useState(null);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState('');

  useEffect(() => {
    axios.get(`/schedules/${scheduleId}`)
      .then(res => {
        setScheduleData(res.data);
        setLoading(false);
      })
      .catch(() => {
        setError('Error loading schedule.');
        setLoading(false);
      });
  }, [scheduleId]);

  const handleSubmit = (formData) => {
    axios.put(`/schedules/${scheduleId}`, formData)
      .then(() => {
        alert("Schedule updated successfully!");
        onClose();
      })
      .catch(() => alert("Error updating schedule."));
  };

  return (
    <Modal title="Update Schedule" onClose={onClose}>
      {loading ? <div>Loading...</div> : error ? <div style={{ color: 'red' }}>{error}</div> :
        <ScheduleForm onSubmit={handleSubmit} initialData={scheduleData} />}
    </Modal>
  );
};

export default ScheduleUpdate;