
// Schedule/ScheduleDB.js
import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const ScheduleDB = ({ scheduleId, onClose }) => {
  const [isSubmitting, setSubmitting] = useState(false);
  const [error, setError] = useState('');

  const deleteSchedule = () => {
    if (isSubmitting) return;
    setSubmitting(true);
    axios.delete(`/schedules/${scheduleId}`)
      .then(() => {
        alert("Schedule deleted successfully.");
        onClose();
      })
      .catch(() => {
        setError("Error deleting schedule.");
        setSubmitting(false);
      });
  };

  return (
    <Modal title="Delete Schedule" onClose={onClose}>
      {error && <p style={{ color: 'red' }}>{error}</p>}
      <p>Are you sure you want to delete this schedule?</p>
      <button onClick={deleteSchedule} disabled={isSubmitting}>Confirm</button>
      <button onClick={onClose}>Cancel</button>
    </Modal>
  );
};

export default ScheduleDB;