// Schedule/AddSchedule.js
import React from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';
import ScheduleForm from './ScheduleForm';

const AddSchedule = ({ onClose, onCreateSuccess }) => {
  const handleSubmit = (formData) => {

 const account_id = localStorage.getItem('account_id');
 const user_id = localStorage.getItem('user_id');

    const payload = {
      ...formData,
      account_id,
      user_id
    };

    axios.post(`/schedules/`, payload)
      .then(res => {
        alert("Schedule created successfully!");
        if (onCreateSuccess) onCreateSuccess(res.data);
        if (onClose) onClose();
      })
      .catch(err => {
        alert("Error creating schedule.");
        console.error(err);
      });
  };

  return (
    // <Modal title="New Schedule" onClose={onClose}>
      <ScheduleForm onSubmit={handleSubmit} />
    /* </Modal> */
  );
};

export default AddSchedule;