import React from 'react';
import Tabs from '../../common/Tabs';
import PricingRulesList from './PricingRulesList';
import NewPricingRule from './AddPricingRule';

const PricingRules = () => {
    const tabsData = [
        { id: 'pricing_list', label: 'List'  },
        { id: 'new_pricing', label: 'Add' },
    ];

    return (
        <div className="pricing-container">
            <Tabs tabs={tabsData}>
                {(activeTab) => {
                    switch (activeTab) {
                        case 'pricing_list':
                            return <PricingRulesList />;
                        case 'new_pricing':
                            return <NewPricingRule />;
                        default:
                            return null;
                    }
                }}
            </Tabs>
        </div>
    );
};

export default PricingRules;