import React, { useState, useEffect } from 'react';
import axios from 'axios';
import PricingRulesForm from './PricingRulesForm';
import Modal from '../../Layouts/Modal';

const PricingRulesUpdate = ({ pricingRuleId, onClose, onUpdateSuccess }) => {
    const [pricingRuleData, setPricingRuleData] = useState(null);
    const [loading, setLoading] = useState(true);
    const [error, setError] = useState('');

    useEffect(() => {
        axios.get(`/pricingrules/${pricingRuleId}`)
            .then(res => {
                const formData = {
                    ...res.data,
                    pricing_type: res.data.pricing_type.toString()
                };
                setPricingRuleData(formData);
                setLoading(false);
            })
            .catch(err => {
                setError('Error fetching pricing rule data.');
                setLoading(false);
            });
    }, [pricingRuleId]);

const handleSubmit = (formData) => {
    const account_id = localStorage.getItem('account_id');
    const user_id = localStorage.getItem('user_id');
    const payload = {
        ...formData,
        account_id,
        user_id
    };

    axios.put(`/pricingrules/${pricingRuleId}`, payload)
        .then(res => {
            alert("Pricing rule updated successfully!");
            if (onUpdateSuccess) onUpdateSuccess(res.data);
            onClose();
        })
        .catch(err => {
            alert("Error updating pricing rule.");
            console.error(err);
        });
};

    return (
        <Modal title="Edit Pricing Rule" onClose={onClose}>
            {loading ? (
                <div>Loading pricing rule data...</div>
            ) : error ? (
                <div style={{ color: 'red' }}>{error}</div>
            ) : (
                <PricingRulesForm 
                    initialData={pricingRuleData} 
                    onSubmit={handleSubmit} 
                />
            )}
        </Modal>
    );
};

export default PricingRulesUpdate;