import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const PricingRulesDB = ({ pricingRuleId, onClose, onDeleteSuccess }) => {
    const [isSubmitting, setSubmitting] = useState(false);
    const [error, setError] = useState('');

    const deletePricingRule = () => {
        if (isSubmitting) return;
        setSubmitting(true);

        // Static account_id and user_id
      
 const account_id = localStorage.getItem('account_id');
 const user_id = localStorage.getItem('user_id');

        axios.delete(`/pricingrules/${pricingRuleId}`, {
            data: { account_id, user_id }
        })
            .then(res => {
                alert("Pricing rule deleted successfully.");
                if (onDeleteSuccess) onDeleteSuccess();
                onClose();
            })
            .catch(err => {
                setError("Error deleting pricing rule.");
            })
            .finally(() => {
                setSubmitting(false);
            });
    };

    return (
        <Modal title="Delete Pricing Rule" onClose={onClose}>
            {error && <p style={{ color: 'red' }}>{error}</p>}
            <p>Are you sure you want to delete this pricing rule?</p>
            <button onClick={deletePricingRule} disabled={isSubmitting}  style={{ marginRight: '10px' }}>Confirm</button>
            <button onClick={onClose}>Cancel</button>
        </Modal>
    );
};

export default PricingRulesDB;