import React from 'react';
import axios from 'axios';
import { useNavigate } from 'react-router-dom'; // Add this import
import Modal from '../../Layouts/Modal';
import PricingRulesForm from './PricingRulesForm';

const NewPricingRules = ({ onClose, onCreateSuccess }) => {
    const navigate = useNavigate(); // Get the navigate function

    const handleSubmit = (formData) => {
        // Static account_id and user_id
        const account_id = localStorage.getItem('account_id');
        const user_id = localStorage.getItem('user_id');

        // Add account_id and user_id to the payload
        const payload = {
            ...formData,
            account_id, 
            user_id 
        };

        console.log("Payload:", payload); 

        axios.post(`/pricingrules/`, payload)
            .then(res => {
                alert("Pricing rule created successfully!");
                if (onCreateSuccess) onCreateSuccess(res.data);
                if (onClose) onClose();
                // navigate('/pricingrules/'); // Redirect after alert is closed
            })
            .catch(err => {
                alert("Error creating Pricing rule.");
                console.error(err);
            });
    };

    return (
        <div>
            <PricingRulesForm onSubmit={handleSubmit} />
        </div>
    );
};

export default NewPricingRules;