// src/components/pages/Dashboard/index.js
import React, { useState, useEffect } from 'react';
import CXA from '../CXAsync';
import { useParams, useLocation, Link } from 'react-router-dom';

import axios from 'axios';
import Select from 'react-select'; // Assuming you're using react-select for the dropdown

const AIWorkers = () => {
  const [agents, setAgents] = useState([]);
  const [selectedAgent, setSelectedAgent] = useState(null);
  const [showAllAgents, setShowAllAgents] = useState(false);
  const account_id = localStorage.getItem('account_id');
  const userId = localStorage.getItem('user_id');
  const { projectId, interactionId } = useParams(); // Destructure needed params from URL

  useEffect(() => {
    if (projectId) {
      // Simulate fetching data for this project
      setSelectedAgent(previousState => ({
        ...previousState,
        project_id: projectId,
        interactionId: interactionId  // Assuming we might also need interactionId in the agent
      }));
    }else{
      setSelectedAgent(null);
    }
  }, [projectId, interactionId]);
   
  useEffect(() => {
    if (projectId) {
      setSelectedAgent({ project_id: projectId }); // Assuming we need at least project_id
      return;
    }

    const fetchDataUrl = `/projects/${account_id}/?limit=50`;
    axios.get(fetchDataUrl)
      .then(response => {
        // Make sure to access the nested 'projects' array
        const projects = response.data.projects;
        //console.log(projects);
        if (Array.isArray(projects)) {
          setAgents(projects);
        } else {
          console.error("Unexpected API response structure for projects:", projects);
          setAgents([]);
        }
      })
      .catch(error => {
        console.error("Error fetching projects:", error);
        setAgents([]); // Fallback to empty array on error
      });
  }, [account_id]);
  
  if (!selectedAgent) {
    return (
      <div className="projects-container" >
            <center>
                <div className='content-container' >
                    {/* Introduction Section */}
                    <section className="main-section">
                    <img src='/logo.png' style={{width:'50px'}} />
                        <h2>How can i help you today?</h2>
        <h3>Get started with our AI Workers</h3>
        <div style={{ display: 'flex', flexWrap: 'wrap', alignItems: 'center', justifyContent: 'center' }}>
        {agents.slice(0, 10).map(agent => (
          <button key={agent.project_id}  onClick={() => setSelectedAgent(agent)} style={{ borderRadius: '20px', margin: '5px' }}>
            {agent.cx_agent_name}
          </button>
        ))}
        {agents.length > 10 && !showAllAgents && (
          <Link to='#' onClick={() => setShowAllAgents(true)} style={{ borderRadius: '20px', margin: '5px' }}>
             <span className="material-symbols-outlined">chevron_right</span>Show All Workers
          </Link>
        )}
        </div>
        {showAllAgents && (
        <>
        <br/>
          <Select
            options={agents.map(agent => ({ value: agent.cx_agent_name, label: agent.cx_agent_name }))}
            onChange={option => setSelectedAgent(agents.find(agent => agent.cx_agent_name === option.value))}
            placeholder="Select an agent..."
          />
          </>
        )}
        {agents.length === 0 && <p>There are no active agents, please talk to your team to get started.</p>}
        </section>
        </div>
        </center>
      </div>
    );
  }

  // Render the CXA component for the selected agent
  return (
    <div className="projects-container">
      <div className="layout-container">
        <div className="body-section">
          <CXA project_id={selectedAgent.project_id} userId={userId} interactionHID={selectedAgent.interactionId} />
        </div>
      </div>
    </div>
  );
};

export default AIWorkers;
