import React, { useEffect, useState } from 'react';
import axios from 'axios';
import { Link, useLocation } from 'react-router-dom';

const History = () => {
    const location = useLocation();
    const [messages, setMessages] = useState([]);
    const [loading, setLoading] = useState(false);
    const [page, setPage] = useState(1);
    const userId = localStorage.getItem('user_id');
    const accountId = localStorage.getItem('account_id')
    const baseUrl = `/interactions/${accountId}/`;

    // Function to fetch data
    const fetchMessages = async () => {
        setLoading(true);
        const response = await axios.get(`${baseUrl}?page=${page}&user=y`);
        //console.log(response.data.interactions);
        setMessages(prevMessages => [...prevMessages, ...response.data.interactions]);
        setLoading(false);
    };

    // Handle scroll to load more
    useEffect(() => {
        const handleScroll = () => {
            if (window.innerHeight + document.documentElement.scrollTop !== document.documentElement.offsetHeight) return;
            setPage(prevPage => prevPage + 1);
        };
        window.addEventListener('scroll', handleScroll);
        return () => window.removeEventListener('scroll', handleScroll);
    }, []);

    // Fetch initial messages
    useEffect(() => {
        fetchMessages();
    }, [page]);

    const truncate = (text) => {
        return text.length > 20 ? text.substring(0, 20) + '...' : text;
    };

    const isMenuItemActive = (path) => {
      return location.pathname.startsWith(path);
    };
  

    return (
        <>
            {messages.map((message, index) => (
                <Link to={`/ai.workers/${message.project_id}/${message.interaction_id}`} key={message.interaction_id} className={`menu-item ${isMenuItemActive(`/ai.workers/${message.project_id}/${message.interaction_id}`) ? "selected" : ""}`}> 
                    <div className="message-title">
                        {truncate(message.chat_title)}
                    </div>
                </Link>
            ))}
            {loading && <p>Loading more...</p>}
        </>
    );
};
export default History;
