import React, { useState, useEffect } from 'react';
import { useNavigate } from 'react-router-dom';
import axios from 'axios';

const Forgot = () => {
    const [email, setEmail] = useState('');
    const navigate = useNavigate();
    const [errorMessage, setErrorMessage] = useState('');
    const userId = localStorage.getItem('user_id') || null;
    const [isSubmitting, setIsSubmitting] = useState(false); // Track whether a submission is in progress

    useEffect(() => {
        if (userId) {
            navigate('/dash');
        }
    }, [userId, navigate]); // Adding navigate as a dependency as well

    const handleContinue = async () => {
        if (isSubmitting) return; // Prevent multiple submissions

        if (!isValidEmail()) {
            setErrorMessage('Your email is invalid!!');
            return;
        }
        try {
            setIsSubmitting(true); // Disable the submit button
            const response = await axios.post('/users/emailverification/', {
                emails:email,
                action:'forgot'
            });
            const status = response.data.status;
            
            if(status ==2){
                setErrorMessage('User is not exists. Please enter a valid email ID.'); // Update the error message
                setIsSubmitting(false); // Re-enable the submit button
            }
            if(status ==3){
                navigate('/reset-password', { state: { email } });
            }
            return;

        } catch (error) {
            console.error('Error during email validation:', error);
            setErrorMessage('Error during email validation.'); // Update the error message
            setIsSubmitting(false); // Re-enable the submit button
        }
    };
    const isValidEmail = () => {
        const pattern = /^[a-zA-Z0-9._-]+@[a-zA-Z0-9.-]+\.[a-zA-Z]{2,4}$/;
        return pattern.test(email);
    };

    return (
        <div className="container">
            <h2>Forgot your password!</h2>
            <p className="note">Please enter your email to continue!</p>

            <input
                type="email"
                id="email"
                placeholder="Email address"
                value={email}
                onChange={(e) => setEmail(e.target.value)}
                className="input"
            />
            {errorMessage && <p className="error">{errorMessage}</p>}
            <br/>
            <button onClick={handleContinue} className="button" disabled={isSubmitting}>
                {isSubmitting ? 'Progressing ...' : 'Submit'}
            </button>
        </div>
    );
};

export default Forgot;
