import React, { useEffect } from 'react';
import { useNavigate } from 'react-router-dom';
import axios from 'axios';

const Logout = () => {
  const navigate = useNavigate();

  useEffect(() => {
    const signOutProcess = async () => {
      // Check if the user is signed in with Google
      const isGoogleSignIn = localStorage.getItem('isGoogleSignIn') === 'true';

      if (isGoogleSignIn) {
        await googleSignOut();
      }

      // Clear all stored data and redirect to login.
      clearDataAndRedirect();
    };

    const googleSignOut = async () => {
      if (window.google && window.google.accounts) {
        try {
          await new Promise((resolve) => {
            window.google.accounts.id.revoke(localStorage.getItem('email'), () => {
              console.log('Google access revoked');
              resolve();
            });
          });
        } catch (error) {
          console.error('Error during Google sign-out:', error);
        }
      } else {
        console.error('Google Identity Services library is not loaded. Proceeding with normal logout.');
      }
    };

    const clearDataAndRedirect = () => {
      // Clear all storage
      localStorage.clear();
      sessionStorage.clear();

      // Remove any axios default authorization header.
      delete axios.defaults.headers.common['Authorization'];

      // Delete all cookies
      deleteAllCookies();

      // Optionally force a reload if your app uses contexts that need to reinitialize.
      navigate('/login', { replace: true });
    };

    const deleteAllCookies = () => {
      const cookies = document.cookie.split(";");
      for (let cookie of cookies) {
        const eqPos = cookie.indexOf("=");
        const name = eqPos > -1 ? cookie.substr(0, eqPos).trim() : cookie.trim();
        // Delete the cookie with path=/ (adjust domain if needed)
        document.cookie = name + "=;expires=Thu, 01 Jan 1970 00:00:00 GMT; path=/";
      }
    };

    signOutProcess();
  }, [navigate]);

  return (
    <div>
      Logging out...
    </div>
  );
};

export default Logout;
