
import { setRBAC } from '../../../state/RBACSlice';

export function storeUserData(userData, dispatch) {
  localStorage.setItem('token', userData.token || "");
  localStorage.setItem('user_id', userData._id || "");
  localStorage.setItem('account_id', userData.account_id || "");
  localStorage.setItem('email', userData.email || "");
  localStorage.setItem('name', userData.name || (userData.email ? userData.email.split('@')[0] : ""));
  localStorage.setItem('mobile', userData.mobile || "");
  localStorage.setItem('last_login', userData.last_login || "");
  localStorage.setItem('account_type', userData.account_type || 0);
  localStorage.setItem('subscription_id', userData.subscription_id || "");
  localStorage.setItem('subscription_status', userData.subscription_status || "");
  localStorage.setItem('subscription_type', userData.account_type || 0); // adjust if needed
  localStorage.setItem('subscription_agents', userData.subscription_agents || 0);
  localStorage.setItem('active_agents', userData.active_agents || 0);
  
  // For roles: if there's no account_id, default role might be 2, else 3 (adjust logic as needed)
  if (userData.account_id === "") {
    localStorage.setItem('roles', userData.roles || 100); // Common New Account Owner
  } else {
    localStorage.setItem('roles', userData.roles || 101); // Common New Account Manager
  }
  localStorage.setItem('picurl', userData.picurl || "");
  
  // Store role rights and role features as JSON strings.
  if(userData.role_rights) {
    localStorage.setItem('role_rights', JSON.stringify(userData.role_rights));
  }
  localStorage.setItem('role_features', JSON.stringify(userData.role_features));

  // Update a version/timestamp to signal a change.
  localStorage.setItem('rbacVersion', Date.now().toString());

  // Redux dispatch
  dispatch(setRBAC({
    roleRights: userData.role_rights || {},
    roleFeatures: userData.role_features || [],
  }));
  

  //console.log('User data stored in localStorage:', localStorage.getItem('role_features'));
}
