import React from 'react';
import Tabs from '../../common/Tabs';
import TasksList from './TaskList';
import NewTask from './AddTask';
import '../../themes/blue/Tasks.css';

const Tasks = () => {
    const tabsData = [
        { id: 'tasks_list', label: 'Tasks' },
        { id: 'new_task', label: 'Add' },
    ];

    return (
        <div className="tasks-container">
          
            <Tabs tabs={tabsData}>
                {(activeTab) => {
                    switch (activeTab) {
                        case 'tasks_list':
                            return <TasksList />;
                        case 'new_task':
                            return <NewTask />;
                        default:
                            return null;
                    }
                }}
            </Tabs>
        </div>
    );
};

export default Tasks;