import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const TaskDB = ({ taskId, onClose, onDeleteSuccess }) => {
    const [isSubmitting, setSubmitting] = useState(false);
    const [error, setError] = useState('');

    const deleteTask = () => {
        if (isSubmitting) return;
        setSubmitting(true);
        axios.delete(`/tasks/${taskId}`)
            .then(res => {
                alert("Task deleted successfully.");
                if (onDeleteSuccess) onDeleteSuccess();
                onClose();
            })
            .catch(err => {
                setError("Error deleting task.");
            })
            .finally(() => {
                setSubmitting(false);
            });
    };

    return (
        <Modal title="Delete Task" onClose={onClose}>
            {error && <p style={{ color: 'red' }}>{error}</p>}
            <p>Are you sure you want to delete this task?</p>
            <button onClick={deleteTask} disabled={isSubmitting}>Confirm</button>
            <button onClick={onClose}>Cancel</button>
        </Modal>
    );
};

export default TaskDB;