import React from 'react';
import { useNavigate, useParams } from 'react-router-dom';
import { useState } from 'react';
import Tabs from "../../common/Tabs";
import AppsList from "./Apps";
import IntegrationsList from "./AppIntegrations";
const Integrations = () => {
    const roles = localStorage.getItem('roles') || '1';
    const navigate = useNavigate();
    const { app_id } = useParams();
    const [appId, setAppId] = useState(null);
    const [activeTab, setActiveTab] = React.useState(app_id ? 'newapp' : 'appslist');
    const tabsData = [
        { id: 'appslist', label: 'App Store' },
        { id: 'integrations', label: 'Integrations' },
        { id: 'build', label: '+ Build Your App' }
    ];
    const handleTabChange = (newActiveTab) => {
        setActiveTab(newActiveTab);
    };
    return (
        <div className="dashboard-container">
            <h2>Apps</h2>
            <p>Browse and discover: A curated selection of marketplace apps ready for integration with our platform</p>
            <Tabs tabs={tabsData} activeTabId={activeTab} onTabChange={handleTabChange}>
                {(currentTab) => {
                    switch(currentTab) {
                        case 'appslist':
                            return (
                                <div className="AppsList newactive">
                                    <AppsList setActiveTab={setActiveTab} setAppId={setAppId} initialSearchQuery="" />
                                </div>
                            );
                        case 'integrations':
                            return (
                                <div className="IntegrationsList newactive">
                                    <IntegrationsList setActiveTab={setActiveTab} />
                                </div>
                            );
                        case 'build':
                            return(
                                <div>
                                    <p>You can integrate any custom applications with AI Agent to push & pull data from your apps. This feature is available only for Enterprise version. </p>
                                </div>
                            );
                        default:
                            return null;
                    }
                }}
            </Tabs>
        </div>
    );
};
export default Integrations;