import React, {useEffect, useState} from "react";
import { useNavigate } from "react-router-dom";
import SearchPage from '../../common/SearchPage';
import List from '../../common/List/Icons';
import IntegrationModal from '../../common/Modal/Integration';
const PROJECTS_HEADER_TO_KEY_MAP = {
    "Name": "name",
    "Title": "title",
    "Integrations": "integrations",
    "Icon": "icon",
    "Date": "updated_date",
    "Status": "status",
  };
  const AppsList = ({ initialSearchQuery = '', rowsPerPage = 50, setActiveTab, setAppId }) => {
    const fetchDataUrl = `/appflow/`; //apps
    const [selectedAppId, setSelectedAppId] = useState(null);
    const [showModal, setShowModal] = useState(false);
    const actionFormats = [
      { label: "+Add", url: "/a/apps/integrate/{id}" }
    ];
    const handleActionClick = (app_id, action) => {
      
      if (action.label === "+Add") {
          setSelectedAppId(app_id);
          setShowModal(true);
      } else if(action.label === "remove") {
          //console.log("remove logic here");
      }
  };
              
      return (
        <div>
        <SearchPage
          fetchDataUrl={fetchDataUrl}
          ListComponent={List}
          itemKeyMapping={PROJECTS_HEADER_TO_KEY_MAP}
          dataKey="apps"
          identifierKey="_id"
          initialSearchQuery={initialSearchQuery}
          rowsPerPage={rowsPerPage}
          actionFormats={actionFormats}
          onActionClick={handleActionClick}
                
        />
        { selectedAppId && (
            <IntegrationModal
            appId={selectedAppId} 
            onClose={() => setSelectedAppId(null)} 
            />
        )}
    
        </div>
      );
    }
export default AppsList;