import React, { useEffect, useState } from "react";
import SearchPage from '../../common/SearchPage';
//import List from '../../common/List/index';
import List from '../../common/List/Icons';
import IntegrationModal from '../../common/Modal/Integration';
import DeleteAppIntegrationModal from '../../common/Modal/DeleteAppIntegration';
const INTEGRATIONS_HEADER_TO_KEY_MAP = {
    "Title": "title",
    "API Key": "api_key",
    "Date": "created_date"
};
const IntegrationsList = ({ initialSearchQuery = '', rowsPerPage = 50 }) => {
    const account_id = localStorage.getItem('account_id');
    const fetchDataUrl = `/appflow/integrations/list/${account_id}/`;
    const [selectedIntegrationId, setSelectedIntegrationId] = useState(null);
    const [selectedIntegrationName, setSelectedIntegrationName] = useState('');
    const [integrationItems, setIntegrationItems] = useState([]);
    const [showDeleteModal, setShowDeleteModal] = useState(false); // State to control delete modal visibility
    const [showIntegrationModal, setShowIntegrationModal] = useState(false); // State to control delete modal visibility
    const actionFormats = [
        { label: "edit", modal: true, url: "/a/integrations/edit/{id}" },
        { label: "delete", modal: true, url: "/a/integrations/delete/{id}" }
    ];
    const handleActionClick = (integration_id, action) => {
        const integration = integrationItems.find(item => item["_id"] === integration_id);
        setSelectedIntegrationId(integration_id);
        setSelectedIntegrationName(integration ? integration.name : '');
        if (action.label === "edit") {
            setShowIntegrationModal(true); // Show delete modal
        } else if (action.label === "delete") {
            setShowDeleteModal(true); // Show delete modal
        }
    };
    return (
        <div>
            <SearchPage
                fetchDataUrl={fetchDataUrl}
                ListComponent={List}
                itemKeyMapping={INTEGRATIONS_HEADER_TO_KEY_MAP}
                dataKey="integrations"
                identifierKey="_id"
                initialSearchQuery={initialSearchQuery}
                rowsPerPage={rowsPerPage}
                actionFormats={actionFormats}
                onActionClick={handleActionClick}
            />
            {showIntegrationModal && (
                <IntegrationModal
                    onClose={() => {
                        setSelectedIntegrationId(null);
                        setShowIntegrationModal(false);
                    }}
                    integrationId={selectedIntegrationId}
                />
            )}
            {showDeleteModal && (
                <DeleteAppIntegrationModal
                    accountId={account_id}
                    appIntegrationId={selectedIntegrationId}
                    integrationName={selectedIntegrationName} // Pass the name for better UX
                    onClose={() => {
                        setShowDeleteModal(false);
                        setSelectedIntegrationId(null);
                        setSelectedIntegrationName('');
                    }}
                />
            )}
        </div>
    );
}
export default IntegrationsList;