import React from 'react';
import Tabs from '../../common/Tabs';
import IoTDevicesList from './IoTDeviceList';
import NewIoTDevice from './AddIoTDevice';

const IoTDevices = () => {
  const tabsData = [
    { id: 'list', label: 'List' },
    { id: 'new', label: 'Add' }
  ];

  const tabComponents = {
    list: <IoTDevicesList />,
    new: <NewIoTDevice />
  };

  return (
    <div className="iot-devices-container">
      <Tabs tabs={tabsData}>
        {(activeTab) => tabComponents[activeTab] || null}
      </Tabs>
    </div>
  );
};

export default IoTDevices;