import React, { useState, useEffect } from 'react';
import axios from 'axios';
import IoTDeviceForm from './IoTDeviceForm';
import Modal from '../../Layouts/Modal';

const IoTDeviceUpdate = ({ deviceId, onClose, onUpdateSuccess }) => {
  const [deviceData, setDeviceData] = useState(null);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState('');

  useEffect(() => {
    axios.get(`/iotdevices/${deviceId}`)
      .then(res => {
        setDeviceData(res.data);
        setLoading(false);
      })
      .catch(err => {
        setError("Error fetching device data");
        setLoading(false);
      });
  }, [deviceId]);

  const handleSubmit = (formData) => {
    axios.put(`/iotdevices/${deviceId}`, formData)
      .then(res => {
        alert("Device updated successfully!");
        if (onUpdateSuccess) onUpdateSuccess(res.data);
        onClose();
      })
      .catch(err => {
        alert("Error updating device");
      });
  };

  return (
    <Modal title="Edit IoT Device" onClose={onClose}>
      {loading ? (
        <div>Loading device data...</div>
      ) : error ? (
        <div style={{ color: 'red' }}>{error}</div>
      ) : (
        <IoTDeviceForm initialData={deviceData} onSubmit={handleSubmit} />
      )}
    </Modal>
  );
};

export default IoTDeviceUpdate;