import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const IoTDeviceDelete = ({ deviceId, onClose, onDeleteSuccess }) => {
  const [isSubmitting, setSubmitting] = useState(false);
  const [error, setError] = useState('');

  const deleteDevice = () => {
    if (isSubmitting) return;
    setSubmitting(true);
    
    axios.delete(`/iotdevices/${deviceId}`)
      .then(res => {
        alert("Device deleted successfully!");
        if (onDeleteSuccess) onDeleteSuccess();
        onClose();
      })
      .catch(err => {
        setError("Error deleting device");
      })
      .finally(() => {
        setSubmitting(false);
      });
  };

  return (
    <Modal title="Delete IoT Device" onClose={onClose}>
      {error && <p style={{ color: 'red' }}>{error}</p>}
      <p>Are you sure you want to delete this device?</p>
      <div style={{ display: 'flex', gap: '10px', marginTop: '15px' }}>
        <button onClick={deleteDevice} disabled={isSubmitting}>Confirm</button>
        <button onClick={onClose}>Cancel</button>
      </div>
    </Modal>
  );
};

export default IoTDeviceDelete;