import React from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';
import IoTDeviceForm from './IoTDeviceForm';

const NewIoTDevice = ({ onClose, onCreateSuccess }) => {
  const handleSubmit = (formData) => {
    axios.post('/iotdevices/', formData)
      .then(res => {
        alert("Device created successfully!");
        onCreateSuccess?.(res.data);
        onClose?.();
      })
      .catch(err => {
        alert("Error creating device");
        console.error("Creation error:", err);
      });
  };

  return (
    // <Modal title="New IoT Device" onClose={onClose}>
      <IoTDeviceForm onSubmit={handleSubmit} />
    // </Modal>
  );
};

export default NewIoTDevice;