// GeoFencingRules/index.js
import React from 'react';
import Tabs from '../../common/Tabs';
import GeofencingRuleMappingList from './GeofencingRuleMappingList';
import AddGeofencingRuleMapping from './AddGeofencingRuleMapping';

const GeoFencingRulesMapping = () => {
  const tabsData = [
    { id: 'geofencing_rules_list', label: 'List' },
    { id: 'new_geofencing_rule', label: 'Add' },
  ];

  return (
    <div className="geofencing-rules-container">
      <Tabs tabs={tabsData}>
        {(activeTab) => {
          switch (activeTab) {
            case 'geofencing_rules_list':
              return <GeofencingRuleMappingList />;
            case 'new_geofencing_rule':
              return <AddGeofencingRuleMapping />;
            default:
              return null;
          }
        }}
      </Tabs>
    </div>
  );
};

export default GeoFencingRulesMapping;