import React, { useState, useEffect } from 'react';
import axios from 'axios';
import GeofencingRuleMappingForm from './GeofencingRuleMappingForm';

const GeofencingRuleMappingUpdate = ({ mappingId, onClose, onUpdateSuccess }) => {
  const [mappingData, setMappingData] = useState(null);
  const [loading, setLoading] = useState(true);

  useEffect(() => {
    axios.get(`/geofence_rule_mapping/${mappingId}`)
      .then(res => {
        setMappingData(res.data);
        setLoading(false);
      })
      .catch(err => {
        console.error('Error fetching mapping:', err);
        setLoading(false);
      });
  }, [mappingId]);

  const handleSubmit = (formData) => {
    axios.put(`/geofencerulemappings/${mappingId}`, formData)
      .then(res => {
        onUpdateSuccess?.(res.data);
        onClose?.();
      })
      .catch(err => {
        console.error('Error updating mapping:', err);
      });
  };

  if (loading) return <div>Loading mapping data...</div>;
  if (!mappingData) return <div>Error loading mapping data</div>;

  return (
    <GeofencingRuleMappingForm 
      initialData={mappingData} 
      onSubmit={handleSubmit} 
    />
  );
};

export default GeofencingRuleMappingUpdate;