import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const GeofencingRuleMappingDelete = ({ mappingId, onClose, onDeleteSuccess }) => {
  const [isSubmitting, setIsSubmitting] = useState(false);

  const handleDelete = () => {
    setIsSubmitting(true);
    axios.delete(`/geofence_rule_mapping/${mappingId}`)
      .then(() => {
        onDeleteSuccess?.();
        onClose?.();
      })
      .catch(err => {
        console.error('Error deleting mapping:', err);
        setIsSubmitting(false);
      });
  };

  return (
    <Modal onClose={onClose}>
      <div style={{ padding: '20px' }}>
        <h2>Delete Mapping</h2>
        <p>Are you sure you want to delete this mapping?</p>
        <div style={{ display: 'flex', gap: '10px', marginTop: '20px' }}>
          <button 
            onClick={handleDelete} 
            disabled={isSubmitting}
          >
            {isSubmitting ? 'Deleting...' : 'Confirm Delete'}
          </button>
          <button onClick={onClose}>Cancel</button>
        </div>
      </div>
    </Modal>
  );
};

export default GeofencingRuleMappingDelete;