import React from 'react';
import axios from 'axios';
import GeofencingRuleMappingForm from './GeofencingRuleMappingForm';

const AddGeofencingRuleMapping = ({ onClose, onCreateSuccess }) => {
  const handleSubmit = (formData) => {
    axios.post('/geofence_rule_mapping/', formData)
      .then(res => {
        onCreateSuccess?.(res.data);
        onClose?.();
      })
      .catch(err => {
        console.error('Error creating mapping:', err);
      });
  };

  return <GeofencingRuleMappingForm onSubmit={handleSubmit} />;
};

export default AddGeofencingRuleMapping;