// GeoFencingRules/index.js
import React from 'react';
import Tabs from '../../common/Tabs';
import GeofencingRulesList from './GeofencingRulesList';
import AddGeofencingRule from './AddGeofencingRule';

const GeoFencingRules = () => {
  const tabsData = [
    { id: 'geofencing_rules_list', label: 'List' },
    { id: 'new_geofencing_rule', label: 'Add' },
  ];

  return (
    <div className="geofencing-rules-container">
      <Tabs tabs={tabsData}>
        {(activeTab) => {
          switch (activeTab) {
            case 'geofencing_rules_list':
              return <GeofencingRulesList />;
            case 'new_geofencing_rule':
              return <AddGeofencingRule />;
            default:
              return null;
          }
        }}
      </Tabs>
    </div>
  );
};

export default GeoFencingRules;