// GeoFencingRules/GeofencingRuleUpdate.js
import React, { useState, useEffect } from 'react';
import axios from 'axios';
import GeofencingRuleForm from './GeofencingRuleForm';
import Modal from '../../Layouts/Modal';

const GeofencingRuleUpdate = ({ ruleId, onClose }) => {
  const [ruleData, setRuleData] = useState(null);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState('');

  useEffect(() => {
    axios.get(`/geofencingrules/${ruleId}`)
      .then(res => {
        setRuleData(res.data);
        setLoading(false);
      })
      .catch(() => {
        setError('Error loading rule.');
        setLoading(false);
      });
  }, [ruleId]);

  const handleSubmit = (formData) => {
    axios.put(`/geofencerules/${ruleId}`, formData)
      .then(() => {
        alert("GeoFencing Rule updated successfully!");
        onClose();
      })
      .catch(() => alert("Error updating rule."));
  };

  return (
    <Modal title="Update GeoFencing Rule" onClose={onClose}>
      {loading ? <div>Loading...</div> : error ? <div style={{ color: 'red' }}>{error}</div> :
        <GeofencingRuleForm onSubmit={handleSubmit} initialData={ruleData} />}
    </Modal>
  );
};

export default GeofencingRuleUpdate;