

import React, { useState } from 'react';

const GeofencingRuleForm = ({ onSubmit, onCancel }) => {
  const [ruleName, setRuleName] = useState('');
  const [conditions, setConditions] = useState([{ parameter: '', operator: '', value: '' }]);
  const [selectedAction, setSelectedAction] = useState('');
  const [alertMessage, setAlertMessage] = useState('');
  const [supervisorEmail, setSupervisorEmail] = useState('');
  const [logEvent, setlogEvent] = useState('');

  const [triggerEvents, setTriggerEvents] = useState(['1']);
  const [submitStatus, setSubmitStatus] = useState(null);

  const handleConditionChange = (index, field, value) => {
    const updated = [...conditions];
    updated[index][field] = value;
    setConditions(updated);
  };

  const addCondition = () => {
    setConditions([...conditions, { parameter: '', operator: '', value: '' }]);
  };

  const removeCondition = (index) => {
    if (conditions.length > 1) {
      setConditions(conditions.filter((_, i) => i !== index));
    }
  };

  const handleTriggerEventChange = (e) => {
    const { value, checked } = e.target;
    setTriggerEvents((prev) => checked ? [...prev, value] : prev.filter(v => v !== value));
  };

  const handleSubmit = (e) => {
    e.preventDefault();
    // const payload = {
    //   rule_name: ruleName,
    //   conditions: conditions.filter(c => c.parameter && c.operator && c.value),
    //   action: selectedAction,
    //   alert_message: selectedAction === 'alert_message' ? alertMessage : '',
    //   notify_supervisor: selectedAction === 'notify_supervisor' ? supervisorEmail : '',
    //   log_event: selectedAction === 'log_event' ? logEvent : '',

    //   trigger_events: triggerEvents
    // };

    const payload = {
  rule_name: ruleName,
  conditions: conditions.filter(c => c.parameter && c.operator && c.value),
  action: selectedAction,
  alert_message: selectedAction === 'alert_message' ? alertMessage : '',
  notify_supervisor: selectedAction === 'notify_supervisor' ? supervisorEmail : '',
  log_event: selectedAction === 'log_event' ? logEvent : '',
  trigger_events: triggerEvents[0]  // ✅ Only send the first value (string)
};
    
    if (onSubmit) {
      onSubmit(payload);
    } else {
      console.log('Payload:', payload);
      setSubmitStatus('success');
    }
  };

  return (
    // <div style={{ maxWidth: 800, margin: '0 auto', padding: 20 }}>
    <div style={{ maxWidth: "600px", padding: "20px" }}>


      {submitStatus === 'success' && (
        <div style={{ color: 'green', marginBottom: 10 }}>
          Geofencing rule added successfully!
        </div>
      )}

      <form onSubmit={handleSubmit}>
        <div style={{ marginBottom: 15 }}>
          <label>Rule Name</label><br />
          <input
            type="text"
            placeholder="e.g. Alert if dwell > 5 minutes"
            value={ruleName}
            onChange={(e) => setRuleName(e.target.value)}
            style={{ width: '100%', padding: 8 }}
            required
          />
        </div>

        <div style={{ marginBottom: 15 }}>
          <label>Conditions</label>
          {conditions.map((condition, index) => (
            <div key={index} style={{ display: 'flex', alignItems: 'center', marginBottom: 5 }}>
              <select
                value={condition.parameter}
                onChange={(e) => handleConditionChange(index, 'parameter', e.target.value)}
                style={{ padding: 8, flex: 1 }}
                required
              >
                <option value="">Parameter</option>
                <option value="test1">test1</option>
                <option value="test2">test2</option>
              </select>

              <select
                value={condition.operator}
                onChange={(e) => handleConditionChange(index, 'operator', e.target.value)}
                style={{ marginLeft: 5, padding: 8, flex: 1 }}
                required
              >
                <option value="">Select</option>
                <option value=">">&gt;</option>
                <option value="<">&lt;</option>
                <option value="=">=</option>
                <option value="<=">&le;</option>
                <option value=">=">&ge;</option>
              </select>

              <input
                type="text"
                placeholder="Value"
                value={condition.value}
                onChange={(e) => handleConditionChange(index, 'value', e.target.value)}
                style={{ marginLeft: 5, padding: 8, flex: 1 }}
                required
              />

              {index === conditions.length - 1 ? (
                <button
                  type="button"
                  onClick={addCondition}
                  style={{ 
                    marginLeft: 5, 
                    background: 'none', 
                    border: '1px solid #ccc', 
                    borderRadius: 4,
                    fontSize: 16, 
                    width: 36,
                    height: 36,
                    cursor: 'pointer',
                    color: 'black'
                  }}
                >+</button>
              ) : (
                <button
                  type="button"
                  onClick={() => removeCondition(index)}
                  style={{ 
                    marginLeft: 5, 
                    background: 'none', 
                    border: '1px solid #ccc', 
                    borderRadius: 4,
                    fontSize: 16, 
                    width: 36,
                    height: 36,
                    cursor: 'pointer',
                    color: 'black'
                  }}
                >×</button>
              )}
            </div>
          ))}
        </div>

        <div style={{ marginBottom: 15 }}>
          <label>Action</label><br />
          <select
            value={selectedAction}
            onChange={(e) => setSelectedAction(e.target.value)}
            style={{ width: '100%', padding: 8 }}
            required
          >
            <option value="">Select Action</option>
            <option value="alert_message">Alert Message</option>
            <option value="notify_supervisor">Notify Supervisor</option>
            <option value="log_event">Log Event</option>
          </select>
        </div>

        {selectedAction === 'alert_message' && (
          <div style={{ marginBottom: 15 }}>
            <label>Alert Message</label><br />
            <input
              type="text"
              placeholder="Enter alert message..."
              value={alertMessage}
              onChange={(e) => setAlertMessage(e.target.value)}
              style={{ width: '100%', padding: 8 }}
              required
            />
          </div>
        )}

        {selectedAction === 'notify_supervisor' && (
          <div style={{ marginBottom: 15 }}>
            <label>Supervisor Email</label><br />
            <input
              type="email"
              placeholder="Enter supervisor email..."
              value={supervisorEmail}
              onChange={(e) => setSupervisorEmail(e.target.value)}
              style={{ width: '100%', padding: 8 }}
              required
            />
          </div>
        )}

           {selectedAction === 'log_event' && (
          <div style={{ marginBottom: 15 }}>
            <label>Log Message</label><br />
            <input
              type="text"
              placeholder="Enter log event message..."
              value={logEvent}
              onChange={(e) => setlogEvent(e.target.value)}
              style={{ width: '100%', padding: 8 }}
              required
            />
          </div>
        )}

        <div style={{ marginBottom: 20 }}>
         <fieldset style={{ border: 'none', padding: 0 }}>
  <legend>Trigger Event</legend>
  <label style={{ marginRight: 15 }}>
    <input
      type="radio"
      name="triggerEvent"
      value="enter"
      checked={triggerEvents[0] === 'enter'}
      onChange={(e) => setTriggerEvents([e.target.value])}
    /> Enter
  </label>
  <label style={{ marginRight: 15 }}>
    <input
      type="radio"
      name="triggerEvent"
      value="exit"
      checked={triggerEvents[0] === 'exit'}
      onChange={(e) => setTriggerEvents([e.target.value])}
    /> Exit
  </label>
  <label>
    <input
      type="radio"
      name="triggerEvent"
      value="dwell"
      checked={triggerEvents[0] === 'dwell'}
      onChange={(e) => setTriggerEvents([e.target.value])}
    /> Dwell
  </label>
</fieldset>


        </div>

        <div style={{ display: 'flex', justifyContent: 'flex-start', gap: 10 }}>
          {onCancel && (
            <button 
              type="button" 
              onClick={onCancel}
              style={{ 
                padding: '10px 20px', 
                background: '#f5f5f5', 
                border: '1px solid #ddd',
                borderRadius: 4,
                cursor: 'pointer'
              }}
            >
              Cancel
            </button>
          )}
         <button 
    type="submit"
    style={{ 
      padding: '10px 20px', 
      background: '#f0f0f0', 
      color: '#4CAF50', 
      border: '1px solid white',
      borderRadius: 4,
      cursor: 'pointer',
      fontWeight: 'bold',
      transition: 'all 0.3s ease',
      minWidth: '100px'
    }}
    onMouseEnter={(e) => {
      e.currentTarget.style.background = '#4CAF50';
      e.currentTarget.style.color = '#f0f0f0';
    }}
    onMouseLeave={(e) => {
      e.currentTarget.style.background = '#f0f0f0';
      e.currentTarget.style.color = '#4CAF50';
    }}
  >
    Submit
  </button>
        </div>
      </form>
    </div>
  );
};

export default GeofencingRuleForm;