// GeoFencingRules/GeofencingRuleDB.js
import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const GeofencingRuleDB = ({ ruleId, onClose }) => {
  const [isSubmitting, setSubmitting] = useState(false);
  const [error, setError] = useState('');

  const deleteRule = () => {
    if (isSubmitting) return;
    setSubmitting(true);
    axios.delete(`/geofencerules/${ruleId}`)
      .then(() => {
        alert("GeoFencing Rule deleted successfully.");
        onClose();
      })
      .catch(() => {
        setError("Error deleting rule.");
        setSubmitting(false);
      });
  };

  return (
    <Modal title="Delete GeoFencing Rule" onClose={onClose}>
      {error && <p style={{ color: 'red' }}>{error}</p>}
      <p>Are you sure you want to delete this GeoFencing Rule?</p>
      <button onClick={deleteRule} disabled={isSubmitting}>Confirm</button>
      <button onClick={onClose}>Cancel</button>
    </Modal>
  );
};

export default GeofencingRuleDB;