import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';
import GeofencingRuleForm from './GeofencingRuleForm';

const AddGeofencingRule = ({ onClose, onCreateSuccess }) => {
  const [isSubmitting, setIsSubmitting] = useState(false);
  const [error, setError] = useState(null);

  const handleSubmit = (formData) => {
    setIsSubmitting(true);
    setError(null);
    
    try {
      const account_id = localStorage.getItem('account_id');
      const user_id = localStorage.getItem('user_id');

      if (!account_id || !user_id) {
        throw new Error('User account information not found');
      }

      const payload = {
        ...formData,
        account_id,
        user_id
      };

      axios.post('/geofencerules/', payload)
        .then(res => {
          onCreateSuccess?.(res.data);
          onClose?.();
        })
        .catch(err => {
          setError(err.response?.data?.message || 'Error creating geofencing rule');
          console.error(err);
        })
        .finally(() => {
          setIsSubmitting(false);
        });
    } catch (err) {
      setError(err.message);
      setIsSubmitting(false);
    }
  };

  return (
   <div>
      {error && <div className="error-message">{error}</div>}
      <GeofencingRuleForm 
        onSubmit={handleSubmit} 
        isSubmitting={isSubmitting}
      />
</div>
  );
};

export default AddGeofencingRule;