import React from 'react';
import Tabs from '../../common/Tabs';
import GeofenceList from './GeofenceList';
import AddGeofence from './AddGeofence';

const Geofence = () => {
  const tabsData = [
    { id: 'customer_list', label: 'List' },
    { id: 'new_customer', label: 'Add' },
  ];

  return (
    <div className="customers-container">
      
      <Tabs tabs={tabsData}>
        {(activeTab) => {
          switch (activeTab) {
            case 'customer_list':
              return <GeofenceList />;
            case 'new_customer':
              return <AddGeofence />;
            default:
              return null;
          }
        }}
      </Tabs>
    </div>
  );
};

export default Geofence;
