import React, { useState, useEffect } from 'react';
import axios from 'axios';
import GeofenceForm from './GeofenceForm';
import Modal from '../../Layouts/Modal';

const GeofenceUpdate = ({ geofenceId, onClose }) => {
  const [geofenceData, setGeofenceData] = useState(null);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState('');

  useEffect(() => {
    axios.get(`/geofences/${geofenceId}`)
      .then(res => {
        setGeofenceData(res.data);
        setLoading(false);
      })
      .catch(() => {
        setError('Error loading geofence');
        setLoading(false);
      });
  }, [geofenceId]);

  const handleSubmit = (formData) => {
    axios.put(`/geofences/${geofenceId}`, formData)
      .then(() => {
        alert("Geofence updated successfully!");
        onClose();
      })
      .catch(() => alert("Error updating geofence"));
  };

  return (
    <Modal title="Update Geofence" onClose={onClose}>
      {loading ? <div>Loading...</div> : error ? <div style={{ color: 'red' }}>{error}</div> : (
        <GeofenceForm onSubmit={handleSubmit} initialData={geofenceData} />
      )}
    </Modal>
  );
};

export default GeofenceUpdate;