import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const GeofenceDB = ({ geofenceId, onClose }) => {
  const [isSubmitting, setSubmitting] = useState(false);
  const [error, setError] = useState('');

  const deleteGeofence = () => {
    if (isSubmitting) return;
    setSubmitting(true);
    axios.delete(`/geofences/${geofenceId}`)
      .then(() => {
        alert("Geofence deleted successfully");
        onClose();
      })
      .catch(() => {
        setError("Error deleting geofence");
        setSubmitting(false);
      });
  };

  return (
    <Modal title="Delete Geofence" onClose={onClose}>
      {error && <p style={{ color: 'red' }}>{error}</p>}
      <p>Are you sure you want to delete this geofence?</p>
      <button onClick={deleteGeofence} disabled={isSubmitting}>
        {isSubmitting ? 'Deleting...' : 'Confirm'}
      </button>
      <button onClick={onClose}>Cancel</button>
    </Modal>
  );
};

export default GeofenceDB;