import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';
import GeofenceForm from './GeofenceForm';

const AddGeofence = ({ onClose, onCreateSuccess }) => {
  const [isSubmitting, setIsSubmitting] = useState(false);
  const [error, setError] = useState(null);

  const handleSubmit = (formData) => {
    setIsSubmitting(true);
    setError(null);
    
    try {
      const account_id = localStorage.getItem('account_id');
      const user_id = localStorage.getItem('user_id');

      if (!account_id || !user_id) {
        throw new Error('User account information not found');
      }

      const payload = {
        ...formData,
        account_id,
        user_id
      };

      axios.post('/geofences/', payload)
        .then(res => {
           alert("Geofences created successfully!");
           onCreateSuccess?.(res.data);
          onClose?.();
        })
        .catch(err => {
          setError(err.response?.data?.message || 'Error creating geofence');
          console.error(err);
        })
        .finally(() => {
          setIsSubmitting(false);
        });
    } catch (err) {
      setError(err.message);
      setIsSubmitting(false);
    }
  };

  return (
  <div>
      {error && <div className="error-message">{error}</div>}
      <GeofenceForm 
        onSubmit={handleSubmit} 
        isSubmitting={isSubmitting}
      />
  </div>
  );
};

export default AddGeofence;