import React from 'react';
import Tabs from '../../common/Tabs'; // Ensure correct path
import FleetsList from './FleetsList';
import NewFleet from './AddFleet';
import VehicleModelsList from './VehicleModelsList';
import NewVehicleModel from './AddVehicleModel';
import VendorsList from '../Vendors/VendorList';
import NewVendor from '../Vendors/AddVendor';
// You'll need to create these components

const Fleets = () => {
  // Define tabs with unique IDs
  const tabsData = [
    { id: 'list', label: 'Fleets' },
    { id: 'new', label: 'Add' },
    { id: 'list1', label: 'Models' },
    { id: 'new1', label: 'Add' },
    { id: 'vendors', label: 'Vendors' },
    { id: 'newVendor', label: 'Add' }
  ];

  // Tab content mapping
  const tabComponents = {
    list: <FleetsList />,
    new: <NewFleet />,
    list1: <VehicleModelsList />,
    new1: <NewVehicleModel />,
    vendors: <VendorsList />,
    newVendor: <NewVendor />
  };

  return (
    <div className="fleets-container">
      <Tabs tabs={tabsData}>
        {(activeTab) => tabComponents[activeTab] || null}
      </Tabs>
    </div>
  );
};

export default Fleets;