import React, { useState, useEffect } from 'react';
import axios from 'axios';
import VehicleModelForm from './VehicleModelForm';
import Modal from '../../Layouts/Modal';

const VehicleModelUpdate = ({ modelId, onClose, onUpdateSuccess }) => {
  const [modelData, setModelData] = useState(null);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState('');

  useEffect(() => {
    axios.get(`/vehicle-models/${modelId}`)
      .then(res => {
        setModelData(res.data);
        setLoading(false);
      })
      .catch(err => {
        setError("Error fetching model data");
        setLoading(false);
      });
  }, [modelId]);

  const handleSubmit = (formData) => {
    axios.put(`/vehicle-models/${modelId}`, formData)
      .then(res => {
        alert("Model updated successfully!");
        if (onUpdateSuccess) onUpdateSuccess(res.data);
        onClose();
      })
      .catch(err => {
        alert("Error updating model");
      });
  };

  return (
    <Modal title="Edit Vehicle Model" onClose={onClose}>
      {loading ? (
        <div>Loading model data...</div>
      ) : error ? (
        <div style={{ color: 'red' }}>{error}</div>
      ) : (
        <VehicleModelForm initialData={modelData} onSubmit={handleSubmit} />
      )}
    </Modal>
  );
};

export default VehicleModelUpdate;