import React, { useState } from 'react';
import Form from '@rjsf/core';
import validator from '@rjsf/validator-ajv8';

export const vehicleModelSchema = {
  title: "Vehicle Model Form",
  type: "object",
  required: ["manufacturer_name", "vehicle_type", "fuel_type"],
  properties: {
    manufacturer_name: { type: "string", title: "Manufacturer Name" },
    // vehicle_type: { 
    //   type: "string", 
    //   title: "Model Name",
    //   enum: ["taxi","sedan","suv","truck","van", "drone"],
    //   default: "sedan"
    // },
    vehicle_type: { type: "string", title: "Model Name" },
    
    fuel_type: {
      type: "string",
      title: "Fuel Type",
      enum: ["petrol", "diesel", "electric", "hybrid"],
      default: "petrol"
    },
    is_autonomous: { type: "boolean", title: "Is Autonomous", default: false },
    can_fly: { type: "boolean", title: "Can Fly", default: false },
    capacity_jobs: { 
      type: "integer", 
      title: "Job Capacity",
      minimum: 1,
      default: 1
    },
    number_of_wheels: { 
      type: "integer", 
      title: "Number of Wheels",
      minimum: 0,
      default: 4
    },
    max_speed: { 
      type: "integer", 
      title: "Max Speed (km/h)",
      minimum: 0,
      default: 100
    },
    engine_capacity: { 
      type: "integer", 
      title: "Engine Capacity (cc)",
      minimum: 0,
      default: 1000
    }
  }
};

export const vehicleModelUiSchema = {
  "ui:order": [
    "manufacturer_name",
    "vehicle_type",
    "fuel_type",
    "is_autonomous",
    "can_fly",
    "capacity_jobs",
    "number_of_wheels",
    "max_speed",
    "engine_capacity"
  ]
};

const VehicleModelForm = ({ initialData, onSubmit }) => {
  const [formData, setFormData] = useState({
    vehicle_type: "",
    fuel_type: "Petrol",
    is_autonomous: false,
    can_fly: false,
    capacity_jobs: 1,
    number_of_wheels: 4,
    max_speed: 100,
    engine_capacity: 1000,
    ...initialData
  });
  const [submitted, setSubmitted] = useState(false);

  const handleSubmit = ({ formData }, event) => {
    setSubmitted(true);
    onSubmit(formData);
  };

  const validate = (formData, errors) => {
    // Only validate if form has been submitted
    if (!submitted) {
      return {};
    }
    return errors;
  };

   return (
    <div style={{ maxWidth: "600px", paddingLeft: "20px" }}>
      <style>{`
        button[type="submit"] {
          margin-top: 20px;
        }
      `}</style>

      <Form
        schema={vehicleModelSchema}
        uiSchema={vehicleModelUiSchema}
        formData={formData}
        onChange={({ formData }) => setFormData(formData)}
        onSubmit={handleSubmit}
        validator={validator}
        validate={validate}
        showErrorList={submitted}
        noHtml5Validate
      />
    </div>
  );
};

export default VehicleModelForm;