import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const VehicleModelDelete = ({ modelId, onClose, onDeleteSuccess }) => {
  const [isSubmitting, setSubmitting] = useState(false);
  const [error, setError] = useState('');

  const deleteModel = async () => {
    if (isSubmitting) return;
    setSubmitting(true);
    
    try {
      await axios.delete(`/vehicle-models/${modelId}`);
      alert("Model deleted successfully!");
      onClose();
      if (onDeleteSuccess) {
        onDeleteSuccess(); // This should trigger the refresh in parent component
      }
    } catch (err) {
      setError("Error deleting model");
    } finally {
      setSubmitting(false);
    }
  };

  return (
    <Modal title="Delete Vehicle Model" onClose={onClose}>
      {error && <p style={{ color: 'red' }}>{error}</p>}
      <p>Are you sure you want to delete this vehicle model?</p>
      <div style={{ display: 'flex', gap: '10px', marginTop: '15px' }}>
        <button onClick={deleteModel} disabled={isSubmitting}>
          {isSubmitting ? 'Deleting...' : 'Confirm'}
        </button>
        <button onClick={onClose}>Cancel</button>
      </div>
    </Modal>
  );
};

export default VehicleModelDelete;