import React from 'react';

const VehicleList = ({ vehicles, onRemove }) => {
  return (
    <div className="vehicle-list">
      <h4>Vehicles in Fleet</h4>
      {vehicles.length === 0 ? (
        <p>No vehicles in this fleet</p>
      ) : (
        <table className="vehicle-table">
          <thead>
            <tr>
              <th>ID</th>
              <th>Registration</th>
              <th>VIN</th>
              <th>Model</th>
              <th>Status</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
            {vehicles.map(vehicle => (
              <tr key={vehicle.vehicle_id}>
                <td>{vehicle.vehicle_id}</td>
                <td>{vehicle.registration_number}</td>
                <td>{vehicle.vin_number}</td>
                <td>
                  {vehicle.model_details?.manufacturer_name} - {vehicle.model_details?.vehicle_type}
                </td>
                <td>{vehicle.status}</td>
                <td>
                  <button 
                    onClick={() => onRemove(vehicle.vehicle_id)}
                    className="btn btn-danger"
                  >
                    Remove
                  </button>
                </td>
              </tr>
            ))}
          </tbody>
        </table>
      )}
    </div>
  );
};

export default VehicleList;