import React, { useState, useEffect } from 'react';
import axios from 'axios';
import FleetForm from './FleetForm';
import Modal from '../../Layouts/Modal';
import { useNavigate } from 'react-router-dom';

const FleetUpdate = ({ fleetId, onClose, onUpdateSuccess }) => {
  const [fleetData, setFleetData] = useState(null);
  const [loading, setLoading] = useState(true);
  const navigate = useNavigate();

  useEffect(() => {
    axios.get(`/fleets/${fleetId}`)
      .then(res => {
        setFleetData(res.data);
        setLoading(false);
      })
      .catch(err => {
        console.error("Error fetching fleet:", err);
        setLoading(false);
      });
  }, [fleetId]);

  const handleSubmit = (formData) => {
    axios.put(`/fleets/${fleetId}`, formData)
      .then(res => {
        window.alert("Fleet updated successfully!");
        onUpdateSuccess();
        onClose();
        navigate('/v1/fleets/'); // Redirect to fleets list
      })
      .catch(err => {
        console.error("Error updating fleet:", err);
      });
  };

  return (
    <Modal title="Edit Fleet" onClose={onClose}>
      {loading ? (
        <div>Loading...</div>
      ) : (
        <FleetForm 
          initialData={fleetData} 
          onSubmit={handleSubmit} 
        />
      )}
    </Modal>
  );
};

export default FleetUpdate;