import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const FleetDelete = ({ fleetId, onClose, onDeleteSuccess }) => {
  const [deleting, setDeleting] = useState(false);

  const handleDelete = () => {
    if (deleting) return;
    setDeleting(true);

    axios.delete(`/fleets/${fleetId}`)
      .then(() => {
        onDeleteSuccess();
        onClose();
      })
      .catch(err => {
        console.error("Error deleting fleet:", err);
        setDeleting(false);
      });
  };

  return (
    <>
      <style>{`
        .fleet-button-container {
          display: flex;
          gap: 10px;
          margin-top: 15px;
        }

        .fleet-button {
          padding: 8px 16px;
          border-radius: 4px;
          background-color: #f0f0f0;
          color: #28c76f;
          cursor: pointer;
          transition: background-color 0.3s, color 0.3s;
          font-weight: bold;
          font-size: 14px;
        }

        .fleet-button:hover {
          background-color: #28c76f;
          color: white;
        }

        .fleet-button:disabled {
          background-color: #ccc;
          border-color: #ccc;
          color: #666;
          cursor: not-allowed;
        }
      `}</style>

      <Modal title="Delete Fleet" onClose={onClose}>
        <p>Are you sure you want to delete this fleet?</p>
        <div className="fleet-button-container">
          <button
            onClick={handleDelete}
            disabled={deleting}
            className="fleet-button"
          >
            {deleting ? 'Deleting...' : 'Confirm'}
          </button>
          <button
            onClick={onClose}
            className="fleet-button"
          >
            Cancel
          </button>
        </div>
      </Modal>
    </>
  );
};

export default FleetDelete;


