import React from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';
import VehicleModelForm from './VehicleModelForm';

const NewVehicleModel = ({ onClose, onCreateSuccess }) => {
  const handleSubmit = (formData) => {
    axios.post(`/vehicle-models/`, formData)
      .then(res => {
        alert("Vehicle model created successfully!");
        if (onCreateSuccess) onCreateSuccess(res.data);
        if (onClose) onClose();
      })
      .catch(err => {
        alert("Error creating vehicle model");
      });
  };

  return (
    <div>
      <VehicleModelForm onSubmit={handleSubmit} />
    </div>
  );
};

export default NewVehicleModel;

