// /Dispatch/index.js
import React from 'react';
import Tabs from '../../common/Tabs';
import DispatchPage from './Dispatch';
import SchedulesList from '../Schedule/ScheduleList';
import AddSchedule from '../Schedule/AddSchedule';

export default function DispatchIndex() {
  const tabsData = [
    { id: 'dispatch', label: 'Dispatch' },
    { id: 'schedules', label: 'Schedules' },
    { id: 'new_schedule', label: 'New Schedule' },
  ];

  return (
    <div className="roles-container">
      <Tabs tabs={tabsData}>
        {(activeTab) => {
          switch (activeTab) {
            case 'dispatch':
              return <DispatchPage defaultActiveTab="schedule" />;
            case 'schedules':
              return <SchedulesList />;
            case 'new_schedule':
              return <AddSchedule />;
            default:
              return null;
          }
        }}
      </Tabs>
    </div>
  );
}
