import React from 'react';
import Tabs from '../../common/Tabs';
import CustomerList from './CustomerList';
import AddCustomer from './AddCustomer';

const Customer = () => {
  const tabsData = [
    { id: 'customer_list', label: 'Customers' },
    { id: 'new_customer', label: 'Add' },
  ];

  return (
    <div className="customers-container">
  
      <Tabs tabs={tabsData}>
        {(activeTab) => {
          switch (activeTab) {
            case 'customer_list':
              return <CustomerList />;
            case 'new_customer':
              return <AddCustomer />;
            default:
              return null;
          }
        }}
      </Tabs>
    </div>
  );
};

export default Customer;
