import React, { useState, useEffect } from 'react';
import axios from 'axios';
import CustomerForm from './CustomerForm';
import Modal from '../../Layouts/Modal';

const CustomerUpdate = ({ customerId, onClose }) => {
  const [customerData, setCustomerData] = useState(null);
  const [loading, setLoading] = useState(true);
  const [error, setError] = useState('');

  useEffect(() => {
    axios.get(`/customers/${customerId}`)
      .then(res => {
        setCustomerData(res.data);
        setLoading(false);
      })
      .catch(() => {
        setError('Error loading customer.');
        setLoading(false);
      });
  }, [customerId]);

  const handleSubmit = (formData) => {
    axios.put(`/customers/${customerId}`, formData)
      .then(() => {
        alert("Customer updated successfully!");
        onClose();
      })
      .catch(() => alert("Error updating customer."));
  };

  return (
    <Modal title="Update Customer" onClose={onClose}>
      {loading ? <div>Loading...</div> : error ? <div style={{ color: 'red' }}>{error}</div> :
        <CustomerForm onSubmit={handleSubmit} initialData={customerData} />}
    </Modal>
  );
};

export default CustomerUpdate;