import React, { useState } from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';

const CustomerDB = ({ customerId, onClose }) => {
  const [isSubmitting, setSubmitting] = useState(false);
  const [error, setError] = useState('');

  const deleteCustomer = async () => {
    if (isSubmitting) return;
    setSubmitting(true);
    setError(""); // Clear previous error if any
    try {
      await axios.delete(`/customers/${customerId}`);
      alert("Customer deleted successfully.");
      onClose();
    } catch (err) {
      console.error("Delete error: ", err);
      setError("Error deleting customer. Please try again.");
    } finally {
      setSubmitting(false);
    }
  };

  return (
    <Modal title="Delete Customer" onClose={onClose}>
      {error && <p style={{ color: 'red' }}>{error}</p>}
      <p>Are you sure you want to delete this customer?</p>
      <button onClick={deleteCustomer} disabled={isSubmitting} style={{ marginRight: '10px' }}>Confirm</button>
      <button onClick={onClose}>Cancel</button>
    </Modal>
  );
};

export default CustomerDB;
