import React from 'react';
import axios from 'axios';
import Modal from '../../Layouts/Modal';
import CustomerForm from './CustomerForm';
import { useNavigate } from 'react-router-dom'; // Import useNavigate hook for redirection

const AddCustomer = ({ onClose, onCreateSuccess }) => {
  const navigate = useNavigate();

  const handleSubmit = (formData) => { 
    const account_id = localStorage.getItem('account_id');
    const user_id = localStorage.getItem('user_id');

    const payload = {
      ...formData,
      account_id,
      user_id
    };

    axios.post(`/customers/`, payload)
      .then(res => {
        alert("Customer created successfully!");
        
        // Both options are already here - we'll keep both for redundancy
        if (onCreateSuccess) onCreateSuccess(res.data);
        
        // This is the main redirect that will always work
        navigate('/customers/');
        
        if (onClose) onClose();
      })
      .catch(err => {
        alert("Error creating customer.");
        console.error(err);
      });
  };

  return (
    <div>
      {/* Render CustomerForm with our submit handler */}
      <CustomerForm onSubmit={handleSubmit} />
    </div>
  );
};

export default AddCustomer;