import React, { useState } from 'react';
import SearchPage from '../../common/SearchPage';
import List from '../../common/List';

const PAYMENTS_HEADER_TO_KEY_MAP = {
  "Subscription ID": "subscription_id",
  "Amount": "amount",
  "Due Date": "due_date",
  "Status": "status",
};

const Payments = ({ initialSearchQuery = '', rowsPerPage = 10 }) => {
  const account_id = localStorage.getItem('account_id');
  const fetchDataUrl = account_id ? `/subscriptions/payments/` : ``;

  return (
    <div>
      <SearchPage
        fetchDataUrl={fetchDataUrl}
        ListComponent={List}
        itemKeyMapping={PAYMENTS_HEADER_TO_KEY_MAP}
        dataKey="payments"
        identifierKey="payment_id"
        initialSearchQuery={initialSearchQuery}
        rowsPerPage={rowsPerPage}
      />
    </div>     
  );
}

export default Payments;
