import { useParams, Link } from 'react-router-dom';
import ProjectView from './components/pages/Projects/Project';
// ... Import other components for edit, flows, delete

const ProjectTabs = () => {
  const { type, id } = useParams();

  const renderTabContent = () => {
    switch (type) {
      case 'view':
        return <ProjectView id={id} />;
      case 'edit':
        // return <ProjectEdit id={id} />;
      case 'flows':
        // return <ProjectFlows id={id} />;
      case 'delete':
        // return <ProjectDelete id={id} />;
      default:
        return <div>Select a tab</div>;
    }
  };

  return (
    <div>
      {/* Tab Links */}
      <div className="tabs">
        <Link to={`/projects/v/view/${id}`}>View</Link>
        <Link to={`/projects/v/edit/${id}`}>Edit</Link>
        <Link to={`/projects/v/flows/${id}`}>Flows</Link>
        <Link to={`/projects/v/delete/${id}`}>Delete</Link>
      </div>

      {/* Tab Content */}
      <div className="tab-content">
        {renderTabContent()}
      </div>
    </div>
  );
};

export default ProjectTabs;
