import React, { useState, useEffect } from 'react';
import { Link } from 'react-router-dom';

const Tabs = ({ tabs, children, activeTabId, onTabChange }) => {
    const [localActiveTab, setLocalActiveTab] = useState(activeTabId || tabs[0].id);

    useEffect(() => {
        if (activeTabId) {
            setLocalActiveTab(activeTabId);
        }
    }, [activeTabId]);

    const handleTabClick = (tabId, event) => {
        event.preventDefault();
        setLocalActiveTab(tabId);
        if (onTabChange) {
            onTabChange(tabId);
        }
    };

    return (
        <div className="tabs-container">
            <div className="tab-links">
                {tabs.map(tab => (
                    <Link
                        to={`/${tab.id}`}
                        key={tab.id}
                        onClick={(e) => handleTabClick(tab.id, e)}
                        className={localActiveTab === tab.id ? 'activated' : ''}
                    >
                        {tab.label}
                    </Link>
                ))}
            </div>
            {children(localActiveTab)}
        </div>
    );
}

export default Tabs;
